package elaprendiz.graficos.imagenes;

import java.awt.Image;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.Dimension;

//////////////////////////////////////////////////
// ObjetoImagen extends ObjetosGraficos so load in
// parent.

import elaprendiz.graficos.objetos.ObjetosGraficos;
import java.awt.Color;

public class ObjetoImagen extends ObjetosGraficos {

    /**
     * The image to be drawn.
     */
    protected Image image = null;

    /**
     * The size of the image.
     */
    protected Dimension imageSize = null;

    ////////////////////////////////////////
    // The offset from the origen which 
    // yields the upper left corner where 
    // the image is to be drawn. Note that
    // the variables default to error values.

    protected int widthOffSet  = -1;
    protected int heightOffSet = -1;


    ////////////////////////////////////////
    // Calculate the offsets from the origen

    private void calculateOffSets() {

        ////////////////////////////////////////
        // If image exists then calculate offsets

        if (imageSize != null) {

	    widthOffSet  = imageSize.width  / 2;
	    heightOffSet = imageSize.height / 2;

        ////////////////////////////////////////
        // Else indicate error for future draws

	} else {

	    widthOffSet  = -1;
	    heightOffSet = -1;

	}
    }


    /**
     * Constructor.
     */
    public ObjetoImagen(Point origin, ImageFrame frame, String imageName) {
        super(origin);

	if ( (frame != null) && 
	     (this.image =  frame.getImage(imageName)) != null) {
	  
	    int width  = image.getWidth(frame);
	    int height = image.getHeight(frame);

	    imageSize = new Dimension(width, height);
	
	} else
	    imageSize = null;

	calculateOffSets();
    }

    public ObjetoImagen(ObjetoImagen object) {
        super(new Point(object.origen.x, object.origen.y));

	this.image     = object.image;
	this.imageSize = new Dimension(object.imageSize);

	this.widthOffSet  = object.widthOffSet;
	this.heightOffSet = object.heightOffSet;
    }

    /**
     * Change the image drawn by the ObjetoImagen.
     */
    public synchronized void changeImage(ImageFrame frame, String imageName) {
        if ( (this.image = frame.getImage(imageName)) != null) {

	    int width  = image.getWidth(frame);
	    int height = image.getHeight(frame);

	    if ( (imageSize.width != width) ||
		 (imageSize.height != height)) {
	        
	        imageSize = new Dimension(width, height);
		calculateOffSets();
	    }
	}
    }

    /**
     * Check whether an event occurred within the bounds of the 
     * ObjetoImagen.
     */
    public synchronized boolean inBounds(int x, int y) {
        if ( (widthOffSet == -1) && (heightOffSet == -1))
	  return false;
      
        if ( (x > (origen.x - widthOffSet)) &&
	     (x < (origen.x + widthOffSet)) &&
	     (y > (origen.y - heightOffSet)) &&
	     (y < (origen.y + heightOffSet)))
	  return true;

	return false;
    }

  
    public void move(int x, int y) {
        origen.move(x, y);
    }

    public void translate(int x, int y) {
        origen.translate(x, y);
    }

    public Dimension size() {
        return new Dimension(imageSize);
    }

    public void draw(Graphics g) {
        if (image != null) {            
                g.drawImage(image, origen.x - widthOffSet, origen.y - heightOffSet,
			null);                
	}
	else
	  System.out.println("Image is null");
    }
}
